#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Raymarcher TestMod01.fsh   by  Datwunkid101    
//https://www.shadertoy.com/view/4XsfWS
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec3 rgb( in vec3 hsv ) {
    hsv.x = fract(hsv.x);
    hsv.yz = clamp(hsv.yz, 0.0, 1.0);
    float C = hsv.y*hsv.z;
    float H = hsv.x*6.0;
    float X = C*(1.0-abs(mod(H, 2.0)-1.0));
    vec3 newCol = vec3(0.0);
    if (H <= 1.0) {
        newCol = vec3(C, X, 0.0);
    } else if (H <= 2.0) {
        newCol = vec3(X, C, 0.0);
    } else if (H <= 3.0) {
        newCol = vec3(0.0, C, X);
    } else if (H <= 4.0) {
        newCol = vec3(0.0, X, C);
    } else if (H <= 5.0) {
        newCol = vec3(X, 0.0, C);
    } else {
        newCol = vec3(C, 0.0, X);
    }
    float m = hsv.z-C;
    newCol += m;
    return newCol;
}

//rotation operators
mat2 rotate2D(float angle) {
    return mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
}

//union operators
float opUnion(float d1, float d2) {
    return min(d1, d2);
}
vec4 opUnion(vec4 d1, vec4 d2) {
    return (d1.w < d2.w) ? d1 : d2;
}
vec4 opSubtr(vec4 d1, vec4 d2) {
    return (-d1.w > d2.w) ? -d1 : d2;
}
vec4 opInter(vec4 d1, vec4 d2) {
    float dist = max(d1.w, d2.w);
    vec3 col = mix(d1.rgb, d2.rgb, 0.5);
    return vec4(col, dist);
}
vec4 opSmUnion(vec4 d1, vec4 d2, float k) {
    float h = clamp(0.5 + 0.5*(d2.w-d1.w)/k, 0.0, 1.0);
    float dist = mix(d2.w, d1.w, h) - k*h*(1.0-h);
    vec3 color = mix(d2.rgb, d1.rgb, h);
    return vec4(color, dist);
}
vec4 opSmSubtr(vec4 d1, vec4 d2, float k) {
    float h = clamp(0.5 - 0.5*(d2.w+d1.w)/k, 0.0, 1.0);
    float dist = mix(d2.w, d1.w, h) - k*h*(1.0-h);
    vec3 color = mix(d2.rgb, d1.rgb, h);
    return vec4(color, dist);
}

//signed distance fields
float sdSphere(vec3 position, float size) {
    return length(position) - size;
}

//the data abstracted from the scene at a given point
vec4 map(vec3 position) {
    vec4 returnData = vec4(0.0);
    
    //all the positional data needed for the shapes here
    vec3 q = position;
    q.xz *= rotate2D(iTime/180.0*10.0);
    q = (fract(q*0.5)-0.5)/0.5;
    vec3 q2 = position;
    q2.xz *= rotate2D(-iTime/180.0*10.0);
    q2 = (fract(q2*0.5)-0.5)/0.5;
    vec3 q3 = position;
    q3.xy *= rotate2D(iTime/180.0*10.0);
    q3 = (fract(q3*0.5)-0.5)/0.5;
    vec3 q4 = position;
    q4.xy *= rotate2D(-iTime/180.0*10.0);
    q4 = (fract(q4*0.5)-0.5)/0.5;
    vec3 q5 = position;
    q5.yz *= rotate2D(iTime/180.0*10.0);
    q5 = (fract(q5*0.5)-0.5)/0.5;
    vec3 q6 = position;
    q6.yz *= rotate2D(-iTime/180.0*10.0);
    q6 = (fract(q6*0.5)-0.5)/0.5;
    
    vec4 green = vec4(0.0, 1.0, 0.0, sdSphere(q, 0.2));
    vec4 blue = vec4(0.0, 0.0, 1.0, sdSphere(q2, 0.2));
    vec4 red = vec4(1.0, 0.0, 0.0, sdSphere(q3, 0.2));
    vec4 yellow = vec4(1.0, 1.0, 0.0, sdSphere(q4, 0.2));
    vec4 magenta = vec4(1.0, 0.0, 1.0, sdSphere(q5, 0.2));
    vec4 teal = vec4(0.0, 1.0, 1.0, sdSphere(q6, 0.2));
    
    //distance to scene
    returnData = opSmUnion(
    opSmUnion(
    opSmUnion(
    opSmUnion(
    opSmUnion(green, blue, 0.4),
    red, 0.4),
    yellow, 0.4),
    magenta, 0.4),
    teal, 0.4
    );
    
    return returnData;
}

//for basic lighting effect
vec3 calcNormal(vec3 position) {
    vec2 eps = vec2(0.001, 0.0);
    vec3 normal = vec3(
        (map(position + eps.xyy)).w - (map(position - eps.xyy)).w,
        (map(position + eps.yxy)).w - (map(position - eps.yxy)).w,
        (map(position + eps.yyx)).w - (map(position - eps.yyx)).w
        );
    return normalize(normal);
}

vec4 rayMarch(vec3 origin, vec3 direction, vec3 lightDirection) {
    float totalDistance = 0.0;
    int i;
    for (i = 0; i < 800; i++) {
        vec3 position = origin + direction*totalDistance;
        vec4 newData = map(position);
        float newDistance = newData.w;
        totalDistance += newDistance;
        
        if (totalDistance >= 400.0) {
            break;
        }
        if (newDistance <= 0.001) {
            vec3 normal = calcNormal(position);
            return vec4(vec3(dot(-lightDirection, normal)) * newData.rgb, totalDistance);
        }
    }
    return vec4(0.0);
}

//main function for drawing
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from -1 to 1)
    vec2 uv = fragCoord*2.0/iResolution.xy-1.0;
    float aspectRatio = iResolution.y/iResolution.x;
    uv.y *= aspectRatio;
    vec2 mouse = (iMouse.xy * 2.0 - iResolution.xy)/ iResolution.y;

    // Raymarching
    vec3 col = vec3(0.0);
    vec3 origin = vec3(0.0);
    vec3 direction = normalize(vec3(uv, 1.0));
    direction.yz *= rotate2D(-mouse.y/aspectRatio);
    direction.xz *= rotate2D(-mouse.x);
    
    vec3 lightDirection = vec3(0.0, 0.0, 1.0);
    lightDirection.xz *= rotate2D(iTime);
    
    vec4 march = rayMarch(origin, direction, lightDirection);
    col = march.rgb;
    col = sqrt(col);

    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

